 ; Ŀ
 ;   Dupe - locate duplicate text strings.                                 
 ;   Copyright 1993, 1995, 2005 by Rocket Software Ltd.                    
 ;   Sales tax - government's interpretation of entropy.                   
 ; 

 ; Ŀ
 ;   Pstr - connect points with polylines.                                 
 ;   Arguments: Plist, a list of points.                                   
 ;              Colo, a colour number.                                     
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN PSTR (plist colo / cycles num pa aa)
  (setq cycles (length plist))
  (setq plist (append (list ()) plist))
  (command ".pline")
  (repeat cycles
         (setq plist (cdr plist))
         (setq num 1)
         (setq pa (car plist))
         (while (setq aa (nth num plist))
                (command pa aa pa)
                (setq num (1+ num))))
  (command "")
  (command "change" (entlast) "" "p" "c" colo "")
 (princ))
 ; Ŀ
 ;   Pstr end.                                                             
 ; 

 ; Ŀ
 ;   Sing - grdraw a temporary sine wave.                                  
 ;   Arguments: Pa, a start point.                                         
 ;              Pb, an end point.                                          
 ;              Scal, a wave half amplitude and half height.               
 ;              Colo, colour number.                                       
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SING (pa pb scal colo / angl anginc num pax pay pa)
 ; Ŀ
 ;   Get various scaling and translation parameters.                       
 ; 
  (setq lang (angle pa pb))
  (setq dist (distance pa pb))
  (setq paxa (car pa))
  (setq paya (cadr pa))
 ; Ŀ
 ;   Initialise the sine wave.                                             
 ; 
  (setq angl 0)
  (setq anginc (/ pi 22.5))
  (setq num 0)
 ; Ŀ
 ;   While the distance covered isn't great enough.                        
 ; 
  (while (<= (* angl scal) dist)
         (setq num (1+ num))
 ; Ŀ
 ;   Calculate the next point for an ideal sine wave.                      
 ; 
         (setq pay (sin angl))              ; pax is equal to the angle
 ; Ŀ
 ;   Scale it.                                                             
 ; 
         (setq pax (* scal angl))
         (setq pay (* scal pay))
         (setq pa (list pax pay))
 ; Ŀ
 ;   Rotate and offset the point.                                          
 ; 
         (setq pang (angle '(0 0) pa))
         (setq pa (polar '(0 0) (+ lang pang) (distance '(0 0) pa)))
         (setq pa (list (+ (car pa) paxa) (+ (cadr pa) paya)))
 ; Ŀ
 ;   Draw the point, increment the sine angle.                             
 ; 
         (grdraw pa pa colo)
         (setq angl (+ angl anginc)))
 (princ))
 ; Ŀ
 ;   Sing end.                                                             
 ; 

 ; Ŀ
 ;   Stnam - extract a list ((strings ename) ...) from text and inserts.   
 ;   Arguments: Ss, an ss.                                                 
 ;   Calls nothing, returns a list.                                        
 ; 
 (DEFUN STNAM (ss / num enam typ strlis)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (entget enam))))
         (cond ((= typ "INSERT")
                (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam)))))))
                       (setq strlis (cons (list (cdr (assoc 1 entt)) enam)
                                                                     strlis))))
               ((= typ "TEXT")
                (setq strlis (append strlis (list (list 
                                        (cdr (assoc 1 (entget enam))) enam)))))
               ((= typ "ATTDEF")
                (setq strlis (append strlis (list (list 
                                      (cdr (assoc 2 (entget enam))) enam)))))))
 strlis)
 ; Ŀ
 ;   Stnam end.                                                            
 ; 

 ; Ŀ
 ;   Str - connect points with grlines.                                    
 ;   Arguments: Plist, a list of points.                                   
 ;              Colo, a colour number.                                     
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN STR (plist colo / cycles num pa aa)
  (setq cycles (length plist))
  (setq plist (append (list ()) plist))
  (repeat cycles
         (setq plist (cdr plist))
         (setq num 1)
         (setq pa (car plist))
         (while (setq aa (nth num plist))
                (grdraw pa aa colo)
                (setq num (1+ num))))
 (princ))
 ; Ŀ
 ;   Str end.                                                              
 ; 

 ; Ŀ
 ;   Dupe.                                                                 
 ; 
 (DEFUN C:DUPE (/ *error* osmo glist mtyp ss num enam strlis strnam tmplst
                                           newsub enamtx plist dups sub pa pb)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if shk (print shk))
   (setvar "osmode" osmo)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Get a selection set of text, attdefs, and blocks with attributes.     
 ; 
  (write-line "Select text and blocks or <Return> for all: ")
  (setq glist '((-4 . "<or") (-4 . "<and") (0 . "insert") (66 . 1)
                             (-4 . "and>")
                             (0 . "text") (0 . "attdef") (-4 . "or>")))
  (if (null (setq ss (ssget glist)))
      (setq ss (ssget "x" glist)))
 ; Ŀ
 ;   Ask whether to draw text or sine waves.                               
 ; 
  (initget 0 "Temporary Real Sine Wave")
  (setq mtyp (getkword "Draw Real/Sine Wave/<Temporary> markers: "))
 ; Ŀ
 ;   Make a list of lists: each text/attribute/attdef string and ename.    
 ; 
  (setq strlis (stnam ss))
 ; Ŀ
 ;   Make the list Dups, which will consist of a sublist - for each        
 ;   duplicate string - of all enames containing that string.              
 ; 
  (while (and strlis (setq newsub (car strlis))) ; first string/ename sublist
 ; Ŀ
 ;   Note that the first (string ename) sublist becomes the stub for the   
 ;   tentative ename sublist.  The string is retained as a marker so that  
 ;   new sublists of enames containing the same string can be identified   
 ;   and discarded.                                                        
 ; 
         (setq strlis (cdr strlis))              ; ditch from main list
         (setq tmplst strlis)                    ; copy of main list
 ; Ŀ
 ;   Find each occurrence of the string in the main list: get the string   
 ;   (car newsub) from the first sublist, use (assoc) to find the (string  
 ;   and ename) list in the duplicate main list, then use (member) to      
 ;   get the list and everything after it, (cdr) to remove the current     
 ;   duplicate sublist (which is then attached to Newsub, the tentative     
 ;   duplicate ename sublist).  Repeat this until (member) returns ().     
 ; 
         (while (and (setq enamtx (assoc (car newsub) tmplst))
                     (setq tmplst (member enamtx tmplst)))
                (setq newsub (append newsub (list (cadar tmplst))))
                (setq tmplst (cdr tmplst)))
 ; Ŀ
 ;   Add Newsub to Dupe if:                                                
 ;    1. Newsub has a length of > 1, that is if any duplicates of its      
 ;       string were found.                                                
 ;    2. The first atom in Newsub, the string, doesn't duplicate one in    
 ;       an existing sublist, since an ename can only be a member of one   
 ;       sublist.                                                          
 ; 
         (if (and (> (length newsub) 2)
                  (not (assoc (car newsub) dups)))
             (setq dups (append dups (list newsub)))))
 ; Ŀ
 ;   If any duplicate strings were found then draw polylines between them. 
 ; 
  (setq scal (/ (getvar "viewsize") 90))
  (setq num 0)
  (while (setq sub (cdar dups))
         (setq dups (cdr dups))
         (if (> num 6)
             (setq num 1)
             (setq num (1+ num)))
 ; Ŀ
 ;   List the insertion points for the entities in the current sublist.    
 ; 
         (setq plist ())
         (while (setq enam (car sub))
                (setq sub (cdr sub))
                (setq pa (cdr (assoc 10 (entget enam))))
                (setq plist (cons pa plist)))
 ; Ŀ
 ;   Draw some markers, either temporary or permanent.                     
 ;   Temporary lines.                                                      
 ; 
         (cond ((or (null mtyp) (= mtyp "Temporary"))
                (str plist num))
 ; Ŀ
 ;   Temporary sine waves.                                                 
 ; 
              ((member mtyp '("Sine" "Wave"))
               (setq pb nil)
               (while (setq pa (car plist))
                      (setq plist (cdr plist))
                      (if (and pa pb)
                          (sing pa pb scal num))
                      (setq pb pa)))
 ; Ŀ
 ;   Polylines.                                                            
 ; 
             ((= mtyp "Real")
              (pstr plist num))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))